config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}

preserve_perms etc/rc.d/rc.fail2ban.new
config etc/logrotate.d/fail2ban.new
config etc/fail2ban//fail2ban.conf.new
config etc/fail2ban//jail.conf.new
config etc/fail2ban//paths-common.conf.new
config etc/fail2ban//paths-slackware.conf.new
config etc/fail2ban/action.d/abuseipdb.conf.new
config etc/fail2ban/action.d/apf.conf.new
config etc/fail2ban/action.d/apprise.conf.new
config etc/fail2ban/action.d/blocklist_de.conf.new
config etc/fail2ban/action.d/bsd-ipfw.conf.new
config etc/fail2ban/action.d/cloudflare-token.conf.new
config etc/fail2ban/action.d/cloudflare.conf.new
config etc/fail2ban/action.d/complain.conf.new
config etc/fail2ban/action.d/dshield.conf.new
config etc/fail2ban/action.d/dummy.conf.new
config etc/fail2ban/action.d/firewallcmd-allports.conf.new
config etc/fail2ban/action.d/firewallcmd-common.conf.new
config etc/fail2ban/action.d/firewallcmd-ipset.conf.new
config etc/fail2ban/action.d/firewallcmd-multiport.conf.new
config etc/fail2ban/action.d/firewallcmd-new.conf.new
config etc/fail2ban/action.d/firewallcmd-rich-logging.conf.new
config etc/fail2ban/action.d/firewallcmd-rich-rules.conf.new
config etc/fail2ban/action.d/helpers-common.conf.new
config etc/fail2ban/action.d/hostsdeny.conf.new
config etc/fail2ban/action.d/ipfilter.conf.new
config etc/fail2ban/action.d/ipfw.conf.new
config etc/fail2ban/action.d/iptables-allports.conf.new
config etc/fail2ban/action.d/iptables-ipset-proto4.conf.new
config etc/fail2ban/action.d/iptables-ipset-proto6-allports.conf.new
config etc/fail2ban/action.d/iptables-ipset-proto6.conf.new
config etc/fail2ban/action.d/iptables-ipset.conf.new
config etc/fail2ban/action.d/iptables-multiport-log.conf.new
config etc/fail2ban/action.d/iptables-multiport.conf.new
config etc/fail2ban/action.d/iptables-new.conf.new
config etc/fail2ban/action.d/iptables-xt_recent-echo.conf.new
config etc/fail2ban/action.d/iptables.conf.new
config etc/fail2ban/action.d/ipthreat.conf.new
config etc/fail2ban/action.d/mail-buffered.conf.new
config etc/fail2ban/action.d/mail-whois-common.conf.new
config etc/fail2ban/action.d/mail-whois-lines.conf.new
config etc/fail2ban/action.d/mail-whois.conf.new
config etc/fail2ban/action.d/mail.conf.new
config etc/fail2ban/action.d/mikrotik.conf.new
config etc/fail2ban/action.d/mynetwatchman.conf.new
config etc/fail2ban/action.d/netscaler.conf.new
config etc/fail2ban/action.d/nftables-allports.conf.new
config etc/fail2ban/action.d/nftables-multiport.conf.new
config etc/fail2ban/action.d/nftables.conf.new
config etc/fail2ban/action.d/nginx-block-map.conf.new
config etc/fail2ban/action.d/npf.conf.new
config etc/fail2ban/action.d/nsupdate.conf.new
config etc/fail2ban/action.d/osx-afctl.conf.new
config etc/fail2ban/action.d/osx-ipfw.conf.new
config etc/fail2ban/action.d/pf.conf.new
config etc/fail2ban/action.d/route.conf.new
config etc/fail2ban/action.d/sendmail-buffered.conf.new
config etc/fail2ban/action.d/sendmail-common.conf.new
config etc/fail2ban/action.d/sendmail-geoip-lines.conf.new
config etc/fail2ban/action.d/sendmail-whois-ipjailmatches.conf.new
config etc/fail2ban/action.d/sendmail-whois-ipmatches.conf.new
config etc/fail2ban/action.d/sendmail-whois-lines.conf.new
config etc/fail2ban/action.d/sendmail-whois-matches.conf.new
config etc/fail2ban/action.d/sendmail-whois.conf.new
config etc/fail2ban/action.d/sendmail.conf.new
config etc/fail2ban/action.d/shorewall-ipset-proto6.conf.new
config etc/fail2ban/action.d/shorewall.conf.new
config etc/fail2ban/action.d/smtp.py.new
config etc/fail2ban/action.d/symbiosis-blacklist-allports.conf.new
config etc/fail2ban/action.d/ufw.conf.new
config etc/fail2ban/action.d/xarf-login-attack.conf.new
config etc/fail2ban/filter.d/3proxy.conf.new
config etc/fail2ban/filter.d/apache-auth.conf.new
config etc/fail2ban/filter.d/apache-badbots.conf.new
config etc/fail2ban/filter.d/apache-botsearch.conf.new
config etc/fail2ban/filter.d/apache-common.conf.new
config etc/fail2ban/filter.d/apache-fakegooglebot.conf.new
config etc/fail2ban/filter.d/apache-modsecurity.conf.new
config etc/fail2ban/filter.d/apache-nohome.conf.new
config etc/fail2ban/filter.d/apache-noscript.conf.new
config etc/fail2ban/filter.d/apache-overflows.conf.new
config etc/fail2ban/filter.d/apache-pass.conf.new
config etc/fail2ban/filter.d/apache-shellshock.conf.new
config etc/fail2ban/filter.d/assp.conf.new
config etc/fail2ban/filter.d/asterisk.conf.new
config etc/fail2ban/filter.d/bitwarden.conf.new
config etc/fail2ban/filter.d/botsearch-common.conf.new
config etc/fail2ban/filter.d/centreon.conf.new
config etc/fail2ban/filter.d/common.conf.new
config etc/fail2ban/filter.d/counter-strike.conf.new
config etc/fail2ban/filter.d/courier-auth.conf.new
config etc/fail2ban/filter.d/courier-smtp.conf.new
config etc/fail2ban/filter.d/cyrus-imap.conf.new
config etc/fail2ban/filter.d/dante.conf.new
config etc/fail2ban/filter.d/directadmin.conf.new
config etc/fail2ban/filter.d/domino-smtp.conf.new
config etc/fail2ban/filter.d/dovecot.conf.new
config etc/fail2ban/filter.d/dropbear.conf.new
config etc/fail2ban/filter.d/drupal-auth.conf.new
config etc/fail2ban/filter.d/ejabberd-auth.conf.new
config etc/fail2ban/filter.d/exim-common.conf.new
config etc/fail2ban/filter.d/exim-spam.conf.new
config etc/fail2ban/filter.d/exim.conf.new
config etc/fail2ban/filter.d/freeswitch.conf.new
config etc/fail2ban/filter.d/froxlor-auth.conf.new
config etc/fail2ban/filter.d/gitlab.conf.new
config etc/fail2ban/filter.d/grafana.conf.new
config etc/fail2ban/filter.d/groupoffice.conf.new
config etc/fail2ban/filter.d/gssftpd.conf.new
config etc/fail2ban/filter.d/guacamole.conf.new
config etc/fail2ban/filter.d/haproxy-http-auth.conf.new
config etc/fail2ban/filter.d/horde.conf.new
config etc/fail2ban/filter.d/kerio.conf.new
config etc/fail2ban/filter.d/lighttpd-auth.conf.new
config etc/fail2ban/filter.d/mongodb-auth.conf.new
config etc/fail2ban/filter.d/monit.conf.new
config etc/fail2ban/filter.d/monitorix.conf.new
config etc/fail2ban/filter.d/mssql-auth.conf.new
config etc/fail2ban/filter.d/murmur.conf.new
config etc/fail2ban/filter.d/mysqld-auth.conf.new
config etc/fail2ban/filter.d/nagios.conf.new
config etc/fail2ban/filter.d/named-refused.conf.new
config etc/fail2ban/filter.d/nginx-bad-request.conf.new
config etc/fail2ban/filter.d/nginx-botsearch.conf.new
config etc/fail2ban/filter.d/nginx-error-common.conf.new
config etc/fail2ban/filter.d/nginx-forbidden.conf.new
config etc/fail2ban/filter.d/nginx-http-auth.conf.new
config etc/fail2ban/filter.d/nginx-limit-req.conf.new
config etc/fail2ban/filter.d/nsd.conf.new
config etc/fail2ban/filter.d/openhab.conf.new
config etc/fail2ban/filter.d/openwebmail.conf.new
config etc/fail2ban/filter.d/oracleims.conf.new
config etc/fail2ban/filter.d/pam-generic.conf.new
config etc/fail2ban/filter.d/perdition.conf.new
config etc/fail2ban/filter.d/php-url-fopen.conf.new
config etc/fail2ban/filter.d/phpmyadmin-syslog.conf.new
config etc/fail2ban/filter.d/portsentry.conf.new
config etc/fail2ban/filter.d/postfix.conf.new
config etc/fail2ban/filter.d/proftpd.conf.new
config etc/fail2ban/filter.d/pure-ftpd.conf.new
config etc/fail2ban/filter.d/qmail.conf.new
config etc/fail2ban/filter.d/recidive.conf.new
config etc/fail2ban/filter.d/roundcube-auth.conf.new
config etc/fail2ban/filter.d/routeros-auth.conf.new
config etc/fail2ban/filter.d/scanlogd.conf.new
config etc/fail2ban/filter.d/screensharingd.conf.new
config etc/fail2ban/filter.d/selinux-common.conf.new
config etc/fail2ban/filter.d/selinux-ssh.conf.new
config etc/fail2ban/filter.d/sendmail-auth.conf.new
config etc/fail2ban/filter.d/sendmail-reject.conf.new
config etc/fail2ban/filter.d/sieve.conf.new
config etc/fail2ban/filter.d/slapd.conf.new
config etc/fail2ban/filter.d/softethervpn.conf.new
config etc/fail2ban/filter.d/sogo-auth.conf.new
config etc/fail2ban/filter.d/solid-pop3d.conf.new
config etc/fail2ban/filter.d/squid.conf.new
config etc/fail2ban/filter.d/squirrelmail.conf.new
config etc/fail2ban/filter.d/sshd.conf.new
config etc/fail2ban/filter.d/stunnel.conf.new
config etc/fail2ban/filter.d/suhosin.conf.new
config etc/fail2ban/filter.d/tine20.conf.new
config etc/fail2ban/filter.d/traefik-auth.conf.new
config etc/fail2ban/filter.d/uwimap-auth.conf.new
config etc/fail2ban/filter.d/vsftpd.conf.new
config etc/fail2ban/filter.d/webmin-auth.conf.new
config etc/fail2ban/filter.d/wuftpd.conf.new
config etc/fail2ban/filter.d/xinetd-fail.conf.new
config etc/fail2ban/filter.d/znc-adminlog.conf.new
config etc/fail2ban/filter.d/zoneminder.conf.new
( cd usr/bin ; rm -rf fail2ban-python )
( cd usr/bin ; ln -sf /usr/bin/python3 fail2ban-python )
( cd usr/share/bash-completion/completions ; rm -rf fail2ban-client )
( cd usr/share/bash-completion/completions ; ln -sf fail2ban fail2ban-client )
( cd usr/share/bash-completion/completions ; rm -rf fail2ban-python )
( cd usr/share/bash-completion/completions ; ln -sf fail2ban fail2ban-python )
( cd usr/share/bash-completion/completions ; rm -rf fail2ban-regex )
( cd usr/share/bash-completion/completions ; ln -sf fail2ban fail2ban-regex )
( cd usr/share/bash-completion/completions ; rm -rf fail2ban-server )
( cd usr/share/bash-completion/completions ; ln -sf fail2ban fail2ban-server )
